let lastMeetingId = null;
function broadcastMessage(message, _errorContext) {
  chrome.runtime.sendMessage(message).catch((_error) => {
  });
}
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "getToken") {
    const interactive = request.interactive !== void 0 ? request.interactive : true;
    chrome.identity.getAuthToken({ interactive }, function(token) {
      if (chrome.runtime.lastError) {
        sendResponse({ error: chrome.runtime.lastError.message });
      } else {
        const tokenString = typeof token === "string" ? token : token?.token || "";
        sendResponse({ token: tokenString });
      }
    });
    return true;
  }
  if (request.action === "checkTab") {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      sendResponse({ tabId: tabs[0]?.id, tabUrl: tabs[0]?.url });
    });
    return true;
  }
  switch (request.type) {
    case "muteStateChanged":
      broadcastMessage({
        type: "meetMuteState",
        isMuted: request.isMuted
      });
      sendResponse({ received: true });
      break;
    case "MEETING_ID_IN_CS":
      lastMeetingId = request.id || null;
      break;
    case "meetingEnded":
      broadcastMessage({
        type: "meetingEnded",
        reason: request.reason,
        timestamp: request.timestamp,
        url: request.url
      });
      lastMeetingId = null;
      break;
    case "meetingStateUpdate":
      broadcastMessage({
        type: "meetingStateUpdate",
        state: request.state
      });
      break;
    case "participantCountChanged":
      broadcastMessage({
        type: "participantCountChanged",
        count: request.count,
        timestamp: request.timestamp
      });
      break;
    case "participantsUpdate":
      broadcastMessage({
        type: "participantsUpdate",
        participants: request.participants,
        timestamp: request.timestamp
      });
      break;
    case "screenShareChanged":
      broadcastMessage({
        type: "screenShareChanged",
        isScreenSharing: request.isScreenSharing,
        timestamp: request.timestamp
      });
      break;
    case "recordingStateChanged":
      broadcastMessage({
        type: "recordingStateChanged",
        isRecording: request.isRecording,
        timestamp: request.timestamp
      });
      break;
    case "newChatMessage":
      broadcastMessage({
        type: "newChatMessage",
        message: request.message,
        timestamp: request.timestamp,
        sender: request.sender
      });
      break;
    case "MEETING_ID_IN_BG":
      sendResponse({ meetingId: lastMeetingId });
      break;
  }
  if (request.action === "captureGoogleMeetTab") {
    const tabId = sender.tab?.id;
    const tabUrl = sender.tab?.url;
    if (!tabId || !tabUrl) {
      sendResponse({
        success: false,
        error: "No tab information available"
      });
      return;
    }
    if (!tabUrl.includes("meet.google.com/")) {
      sendResponse({
        success: false,
        error: "Not a Google Meet tab"
      });
      return;
    }
    chrome.tabCapture.capture({
      audio: true,
      video: false
    }, (stream) => {
      if (chrome.runtime.lastError) {
        sendResponse({
          success: false,
          error: `Tab capture failed: ${chrome.runtime.lastError.message}`
        });
        return;
      }
      if (!stream) {
        sendResponse({
          success: false,
          error: "No audio stream received from tab capture"
        });
        return;
      }
      if (!globalThis.tabStreams) {
        globalThis.tabStreams = /* @__PURE__ */ new Map();
      }
      globalThis.tabStreams.set(tabId, stream);
      sendResponse({
        success: true,
        tabId,
        message: "Google Meet tab audio capture successful"
      });
    });
    return true;
  }
  if (request.action === "getTabStream") {
    const tabId = request.tabId || sender.tab?.id;
    if (!tabId || !globalThis.tabStreams || !globalThis.tabStreams.has(tabId)) {
      sendResponse({
        success: false,
        error: "No stream available for this tab"
      });
      return;
    }
    sendResponse({
      success: true,
      hasStream: true,
      message: "Stream is available in background script"
    });
  }
  if (request.action === "proxyAPI") {
    const { url, method, headers, body } = request;
    fetch(url || "", {
      method: method || "GET",
      headers: headers || { "Content-Type": "application/json" },
      body: body ? JSON.stringify(body) : void 0
    }).then((response) => {
      return response.json().then((data) => ({
        ok: response.ok,
        status: response.status,
        data
      }));
    }).then((result) => {
      sendResponse(result);
    }).catch((error) => {
      sendResponse({
        ok: false,
        status: 0,
        error: error.message
      });
    });
    return true;
  }
  return void 0;
});
chrome.action.onClicked.addListener(() => {
  chrome.tabs.create({
    url: "index.html"
  });
});
//# sourceMappingURL=index.ts-BFQMLhcM.js.map
