import { j as jsxRuntimeExports, G as GlassTransparentProvider, u as useGlassTransparent, A as AuthService, c as clientExports } from "./index-BDbae9AU.js";
import { r as reactExports } from "./lucide-CC3hCUHs.js";
import "./react-vendor-BS-dYsv0.js";
(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) return;
  for (const link of document.querySelectorAll('link[rel="modulepreload"]')) processPreload(link);
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") continue;
      for (const node of mutation.addedNodes) if (node.tagName === "LINK" && node.rel === "modulepreload") processPreload(node);
    }
  }).observe(document, {
    childList: true,
    subtree: true
  });
  function getFetchOpts(link) {
    const fetchOpts = {};
    if (link.integrity) fetchOpts.integrity = link.integrity;
    if (link.referrerPolicy) fetchOpts.referrerPolicy = link.referrerPolicy;
    if (link.crossOrigin === "use-credentials") fetchOpts.credentials = "include";
    else if (link.crossOrigin === "anonymous") fetchOpts.credentials = "omit";
    else fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link) {
    if (link.ep) return;
    link.ep = true;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
})();
const AppContent = () => {
  const [user, setUser] = reactExports.useState(null);
  const [isLoading, setIsLoading] = reactExports.useState(true);
  const [isSigningIn, setIsSigningIn] = reactExports.useState(false);
  const [error, setError] = reactExports.useState(null);
  const { isGlassTransparent } = useGlassTransparent();
  const authService = AuthService.getInstance();
  reactExports.useEffect(() => {
    checkAuthStatus();
  }, []);
  const checkAuthStatus = async () => {
    try {
      setIsLoading(true);
      const currentUser = await authService.getCurrentUser();
      const isSignedIn = await authService.isSignedIn();
      if (isSignedIn && currentUser) {
        setUser(currentUser);
        setError(null);
      } else {
        setUser(null);
      }
    } catch (err) {
      setUser(null);
    } finally {
      setIsLoading(false);
    }
  };
  const handleSignIn = async () => {
    try {
      setIsSigningIn(true);
      setError(null);
      const authenticatedUser = await authService.signIn();
      setUser(authenticatedUser);
      setTimeout(() => {
        window.close();
      }, 1e3);
    } catch (err) {
      if (err.message.includes("Techjays employees")) {
        setError("Only Techjays employees are authorized to use this extension");
      } else if (err.message.includes("Token verification failed")) {
        setError("Authentication failed. Please try again.");
      } else if (err.message.includes("User denied")) {
        setError("Google sign-in was cancelled. Please try again.");
      } else {
        setError(err.message || "Authentication failed. Please try again.");
      }
    } finally {
      setIsSigningIn(false);
    }
  };
  const handleSignOut = async () => {
    try {
      setIsLoading(true);
      await authService.signOut();
      setUser(null);
      setError(null);
    } catch (err) {
      setError("Sign out failed. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  const openMeetingCoach = () => {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      const currentTab = tabs[0];
      if (currentTab?.url?.includes("meet.google.com")) {
        window.close();
      } else {
        chrome.tabs.create({ url: "https://meet.google.com" });
        window.close();
      }
    });
  };
  const logoUrl = chrome.runtime.getURL("src/assets/images/techjays_logo.jpg");
  if (isLoading) {
    return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `popup-container ${isGlassTransparent ? "glass-mode-active" : ""}`, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `popup-header ${isGlassTransparent ? "glass-transparent-header" : ""}`, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("img", { src: logoUrl, alt: "Techjays", className: "logo" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: isGlassTransparent ? "glass-transparent-text" : "", children: "Meeting Coach" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `subtitle ${isGlassTransparent ? "glass-transparent-text-muted" : ""}`, children: "Techjays AI Assistant" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `popup-content ${isGlassTransparent ? "glass-transparent-content" : ""}`, children: /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `loading ${isGlassTransparent ? "glass-transparent-text-muted" : ""}`, children: "Checking authentication..." }) })
    ] });
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `popup-container ${isGlassTransparent ? "glass-mode-active" : ""}`, children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `popup-header ${isGlassTransparent ? "glass-transparent-header" : ""}`, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("img", { src: logoUrl, alt: "Techjays", className: "logo" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { className: isGlassTransparent ? "glass-transparent-text" : "", children: "Meeting Coach" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `subtitle ${isGlassTransparent ? "glass-transparent-text-muted" : ""}`, children: "Techjays AI Assistant" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `popup-content ${isGlassTransparent ? "glass-transparent-content" : ""}`, children: !user ? (
      // Sign In View
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "auth-section", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: `welcome-text ${isGlassTransparent ? "glass-transparent-text-muted" : ""}`, children: "Sign in with your Techjays account" }),
        error && /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `error-message ${isGlassTransparent ? "glass-transparent-card" : ""}`, children: error }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "button",
          {
            className: `signin-button ${isGlassTransparent ? "glass-transparent-button" : ""}`,
            onClick: handleSignIn,
            disabled: isSigningIn,
            children: isSigningIn ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "spinner" }),
              "Signing in..."
            ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("svg", { className: "google-icon", viewBox: "0 0 24 24", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("path", { fill: "#4285F4", d: "M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("path", { fill: "#34A853", d: "M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("path", { fill: "#FBBC05", d: "M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("path", { fill: "#EA4335", d: "M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z" })
              ] }),
              "Sign In"
            ] })
          }
        )
      ] })
    ) : (
      // Signed In View
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "authenticated-section", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: `user-info ${isGlassTransparent ? "glass-transparent-card" : ""}`, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "user-avatar", children: user.picture ? /* @__PURE__ */ jsxRuntimeExports.jsx("img", { src: user.picture, alt: user.name }) : /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "avatar-placeholder", children: user.name.charAt(0).toUpperCase() }) }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "user-details", children: /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { className: isGlassTransparent ? "glass-transparent-text" : "", children: user.name }) })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "actions", children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "button",
            {
              className: `primary-button ${isGlassTransparent ? "glass-transparent-button" : ""}`,
              onClick: openMeetingCoach,
              children: "🚀 Launch Meeting Coach"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "button",
            {
              className: `secondary-button ${isGlassTransparent ? "glass-transparent-button" : ""}`,
              onClick: handleSignOut,
              children: "Sign Out"
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: `meeting-status ${isGlassTransparent ? "glass-transparent-status" : ""}`, children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { className: `status-text ${isGlassTransparent ? "glass-transparent-text" : ""}`, children: "✨ Ready for smart meetings" }) })
      ] })
    ) })
  ] });
};
const App = () => {
  return /* @__PURE__ */ jsxRuntimeExports.jsx(GlassTransparentProvider, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(AppContent, {}) });
};
clientExports.createRoot(document.getElementById("root")).render(
  /* @__PURE__ */ jsxRuntimeExports.jsx(reactExports.StrictMode, { children: /* @__PURE__ */ jsxRuntimeExports.jsx(App, {}) })
);
//# sourceMappingURL=index.html-D2EsCIbm.js.map
